<?php
global $pdo;
if (session_status() === PHP_SESSION_NONE) {
    session_set_cookie_params([
        'lifetime' => 0,
        'path' => '/',
        'domain' => '',
        'secure' => isset($_SERVER['HTTPS']),
        'httponly' => true,
        'samesite' => 'Lax'
    ]);
    session_start();
}

require_once '../php/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$username = $_SESSION['username'] ?? 'Utilisateur inconnu';

$stmtUser = $pdo->prepare("SELECT email FROM sae203_utilisateur WHERE id_utilisateur = ?");
$stmtUser->execute([$user_id]);
$email = $stmtUser->fetchColumn() ?? 'Adresse inconnue';

$stmt = $pdo->prepare("
    SELECT b.* FROM sae203_bestiaire b
    JOIN sae203_favoris f ON b.id_monstre = f.id_monstre
    WHERE f.id_utilisateur = ?
");
$stmt->execute([$user_id]);
$favoris = $stmt->fetchAll(PDO::FETCH_ASSOC);

$stmtStuffs = $pdo->prepare("SELECT * FROM sae203_stuffs WHERE id_utilisateur = ?");
$stmtStuffs->execute([$user_id]);
$mes_stuffs = $stmtStuffs->fetchAll(PDO::FETCH_ASSOC);

$stmtFavorisStuffs = $pdo->prepare("
    SELECT s.* FROM sae203_stuffs s
    JOIN sae203_stuff_favoris f ON s.id_stuff = f.id_stuff
    WHERE f.id_utilisateur = ?
");
$stmtFavorisStuffs->execute([$user_id]);
$stuffs_favoris = $stmtFavorisStuffs->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Mon Profil</title>
    <link rel="stylesheet" href="../css/header.css">
    <link rel="stylesheet" href="../css/global.css">
    <link rel="stylesheet" href="../css/profil.css">
</head>
<body>

<?php include '../includes/header.php'; ?>

<div class="profil-page">
    <div class="container">

        <!-- Section Profil Général -->
        <section class="section-profil">
            <h1>👤 Mon profil</h1>
            <div class="infos-profil">
                <p><strong>Pseudo :</strong> <?= htmlspecialchars($username) ?></p>
                <p><strong>Email :</strong> <?= htmlspecialchars($email) ?></p>
                <a href="logout.php"><button>🔓 Se déconnecter</button></a>
            </div>
        </section>

        <!-- Section Monstres Favoris -->
        <section class="section-favoris">
            <h2>📜 Mes monstres favoris</h2>
            <p><a href="../php/monstres.php"><button>🔍 Voir le bestiaire</button></a></p>

            <?php if ($favoris): ?>
                <ul>
                    <?php foreach ($favoris as $monstre): ?>
                        <li>
                            <div class="favori-info">
                                <span class="monstre-nom"><?= htmlspecialchars($monstre['id_monstre']) ?></span>
                                <span class="monstre-niveau">Niv. <?= htmlspecialchars($monstre['Niveau']) ?></span>
                                <span class="monstre-details"><?= htmlspecialchars($monstre['D_tails']) ?></span>
                            </div>
                            <a class="btn-supprimer" href="../php/supprimer_favori.php?id_monstre=<?= urlencode($monstre['id_monstre']) ?>">❌ Supprimer</a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            <?php else: ?>
                <p class="message">Tu n'as pas encore ajouté de monstres à ta liste.</p>
            <?php endif; ?>
        </section>

        <!-- Section Stuffs Créés -->
        <section class="section-stuffs">
            <h2>📦 Mes stuffs créés</h2>
            <p><a href="../php/creer_stuff.php"><button>➕ Créer un nouveau stuff</button></a></p>

            <?php if ($mes_stuffs): ?>
                <ul>
                    <?php foreach ($mes_stuffs as $stuff): ?>
                        <li>
                            <div class="stuff-info">
                                <strong><?= htmlspecialchars($stuff['nom_stuff']) ?></strong><br>
                                <em>
                                    Ceinture : <?= htmlspecialchars($stuff['ceinture']) ?>,
                                    Bouclier : <?= htmlspecialchars($stuff['bouclier']) ?>,
                                    Bottes : <?= htmlspecialchars($stuff['bottes']) ?>,
                                    Anneau : <?= htmlspecialchars($stuff['anneau']) ?>,
                                    Amulette : <?= htmlspecialchars($stuff['amulette']) ?>,
                                    Chapeau : <?= htmlspecialchars($stuff['chapeau']) ?>,
                                    Cape : <?= htmlspecialchars($stuff['cape']) ?>,
                                    Familier : <?= htmlspecialchars($stuff['familier']) ?>,
                                    Arme : <?= htmlspecialchars($stuff['arme']) ?>
                                </em>
                            </div>
                        </li>
                    <?php endforeach; ?>
                </ul>
            <?php else: ?>
                <p class="message">Tu n'as pas encore créé de stuff.</p>
            <?php endif; ?>
        </section>

        <!-- Section Stuffs Favoris -->
        <section class="section-stuffs-favoris">
            <h2>⭐ Stuffs favoris</h2>

            <?php if ($stuffs_favoris): ?>
                <ul>
                    <?php foreach ($stuffs_favoris as $stuff): ?>
                        <li>
                            <div class="stuff-info">
                                <strong><?= htmlspecialchars($stuff['nom_stuff']) ?></strong><br>
                                <em>
                                    Ceinture : <?= htmlspecialchars($stuff['ceinture']) ?>,
                                    Bouclier : <?= htmlspecialchars($stuff['bouclier']) ?>,
                                    Bottes : <?= htmlspecialchars($stuff['bottes']) ?>,
                                    Anneau : <?= htmlspecialchars($stuff['anneau']) ?>,
                                    Amulette : <?= htmlspecialchars($stuff['amulette']) ?>,
                                    Chapeau : <?= htmlspecialchars($stuff['chapeau']) ?>,
                                    Cape : <?= htmlspecialchars($stuff['cape']) ?>,
                                    Familier : <?= htmlspecialchars($stuff['familier']) ?>,
                                    Arme : <?= htmlspecialchars($stuff['arme']) ?>
                                </em>
                            </div>
                            <a class="btn-supprimer" href="../php/supprimer_stuff_favori.php?id_stuff=<?= $stuff['id_stuff'] ?>">❌ Supprimer</a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            <?php else: ?>
                <p class="message">Tu n'as pas encore de stuff en favori.</p>
            <?php endif; ?>
        </section>

    </div> <!-- .container -->
</div> <!-- .profil-page -->

<?php include '../includes/footer.php'; ?>
</body>
</html>
