<?php
// Initialisation propre de la session
global $pdo;
if (session_status() === PHP_SESSION_NONE) {
    session_set_cookie_params([
        'lifetime' => 0,
        'path' => '/',
        'domain' => '',
        'secure' => isset($_SERVER['HTTPS']),
        'httponly' => true,
        'samesite' => 'Lax'
    ]);
    session_start();
}

require_once '../php/db.php'; // Chemin adapté depuis /users/

if (!isset($_SESSION['user_id']) || empty($_GET['id_monstre'])) {
    header("Location: ../users/login.php");
    exit;
}

$id_utilisateur = $_SESSION['user_id'];
$id_monstre = trim($_GET['id_monstre']); // On garde l'ID en chaîne

$stmt = $pdo->prepare("DELETE FROM sae203_favoris WHERE id_utilisateur = ? AND id_monstre = ?");
$stmt->execute([$id_utilisateur, $id_monstre]);

// Redirection vers le profil
header("Location: ../users/profil.php");
exit;
