<?php
if (session_status() === PHP_SESSION_NONE) {
    session_set_cookie_params([
        'lifetime' => 0,
        'path' => '/',
        'domain' => '',
        'secure' => isset($_SERVER['HTTPS']),
        'httponly' => true,
        'samesite' => 'Lax'
    ]);
    session_start();
}

require_once 'db.php';

$monstres = getAllMonstres();
$utilisateur_connecte = isset($_SESSION['user_id']);
$categories = array_unique(array_column($monstres, 'Cat_gorie'));
sort($categories);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Bestiaire - Dofus Helper</title>
    <link rel="stylesheet" href="/sae203/css/global.css">
    <link rel="stylesheet" href="/sae203/css/monstres.css">
</head>
<body>

<?php include '../includes/header.php'; ?>

<div class="content">
    <h1>Liste des Monstres</h1>

    <!-- Filtres -->
    <div class="monstres-filtres">
        <label for="filtreCategorie"></label><select id="filtreCategorie">
            <option value="">Toutes les catégories</option>
            <?php foreach ($categories as $cat): ?>
                <option value="<?= htmlspecialchars($cat) ?>"><?= htmlspecialchars($cat) ?></option>
            <?php endforeach; ?>
        </select>

        <button id="trierNiveau">Trier par niveau ordre décroissant</button>
        <button id="trierAlpha">Trier par niveau ordre croissant</button>
    </div>

    <!-- Tableau -->
    <div class="table-container">
        <table class="monstres-table">
            <thead>
            <tr>
                <th>ID</th>
                <th>Niveau</th>
                <th>Détails</th>
                <th>Catégorie</th>
                <th>Actions</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($monstres as $m): ?>
                <tr class="monstre-row" data-categorie="<?= htmlspecialchars($m['Cat_gorie']) ?>">
                    <td><?= htmlspecialchars($m['id_monstre'] ?? '') ?></td>
                    <td class="col-niveau"><?= htmlspecialchars($m['Niveau'] ?? '') ?></td>
                    <td class="col-details"><?= htmlspecialchars($m['D_tails'] ?? '') ?></td>
                    <td><?= htmlspecialchars($m['Cat_gorie'] ?? '') ?></td>
                    <td>
                        <?php if ($utilisateur_connecte): ?>
                            <form action="../php/ajouter_favori.php" method="GET">
                                <input type="hidden" name="id_monstre" value="<?= htmlspecialchars($m['id_monstre']) ?>">
                                <button type="submit">❤</button>
                            </form>
                        <?php else: ?>
                            <em>Connecte-toi</em>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach ?>
            </tbody>
        </table>
    </div>
</div>

<?php include '../includes/footer.php'; ?>

<!-- JS filtrage + tri -->
<script>
    let ordreNiveauAsc = true;
    let ordreAlphaAsc = true;

    document.getElementById('filtreCategorie').addEventListener('change', () => {
        const cat = document.getElementById('filtreCategorie').value;
        document.querySelectorAll('.monstre-row').forEach(row => {
            const rowCat = row.getAttribute('data-categorie');
            row.style.display = (cat === '' || rowCat === cat) ? '' : 'none';
        });
    });

    document.getElementById('trierNiveau').addEventListener('click', () => {
        const rows = Array.from(document.querySelectorAll('.monstre-row'));
        rows.sort((a, b) => {
            const aNiv = parseInt(a.querySelector('.col-niveau').textContent) || 0;
            const bNiv = parseInt(b.querySelector('.col-niveau').textContent) || 0;
            return ordreNiveauAsc ? aNiv - bNiv : bNiv - aNiv;
        });
        ordreNiveauAsc = !ordreNiveauAsc;
        const tbody = document.querySelector('.monstres-table tbody');
        rows.forEach(row => tbody.appendChild(row));
    });

    document.getElementById('trierAlpha').addEventListener('click', () => {
        const rows = Array.from(document.querySelectorAll('.monstre-row'));
        rows.sort((a, b) => {
            const aNom = a.querySelector('.col-details').textContent.toLowerCase();
            const bNom = b.querySelector('.col-details').textContent.toLowerCase();
            return ordreAlphaAsc ? aNom.localeCompare(bNom) : bNom.localeCompare(aNom);
        });
        ordreAlphaAsc = !ordreAlphaAsc;
        const tbody = document.querySelector('.monstres-table tbody');
        rows.forEach(row => tbody.appendChild(row));
    });
</script>

</body>
</html>
