<?php
if (session_status() === PHP_SESSION_NONE) {
    session_set_cookie_params([
        'lifetime' => 0,
        'path' => '/',
        'domain' => '',
        'secure' => isset($_SERVER['HTTPS']),
        'httponly' => true,
        'samesite' => 'Lax'
    ]);
    session_start();
}
require_once 'db.php';

if (!isset($_SESSION['id_utilisateur'])) {
    header("Location: ../users/login.php");
    exit;
}

$favoris = getFavorisByUtilisateur($_SESSION['id_utilisateur']);
?>


<h2>📜 Liste de mes monstres favoris</h2>

<?php if (count($favoris) > 0): ?>
    <table>
        <thead>
        <tr>
            <th>ID</th>
            <th>Niveau</th>
            <th>Détails</th>
            <th>Catégorie</th>
            <th>Action</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($favoris as $monstre): ?>
            <tr>
                <td><?= htmlspecialchars($monstre['id_monstre']) ?></td>
                <td><?= htmlspecialchars($monstre['Niveau']) ?></td>
                <td><?= htmlspecialchars($monstre['D_tails']) ?></td>
                <td><?= htmlspecialchars($monstre['Cat_gorie']) ?></td>
                <td>
                    <form action="supprimer_favori.php" method="POST" style="display:inline;">
                        <input type="hidden" name="id_monstre" value="<?= $monstre['id_monstre'] ?>">
                        <button type="submit">🗑 Supprimer</button>
                    </form>
                </td>
            </tr>
        <?php endforeach ?>
        </tbody>
    </table>
<?php else: ?>
    <p>Tu n'as encore ajouté aucun monstre à ta liste.</p>
<?php endif; ?>

<a href="monstres.php">🔙 Retour au bestiaire</a>
