<?php
global $pdo;
if (session_status() === PHP_SESSION_NONE) {
    session_set_cookie_params([
        'lifetime' => 0,
        'path' => '/',
        'domain' => '',
        'secure' => isset($_SERVER['HTTPS']),
        'httponly' => true,
        'samesite' => 'Lax'
    ]);
    session_start();
}

require_once 'db.php';

$user_id = $_SESSION['user_id'] ?? null;

// Tous les stuffs de la base
$stmt = $pdo->query("
    SELECT s.*, u.pseudo 
    FROM sae203_stuffs s
    JOIN sae203_utilisateur u ON s.id_utilisateur = u.id_utilisateur
");
$stuffs = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Récupérer les favoris existants
$favoris_ids = [];
if ($user_id) {
    $stmtFav = $pdo->prepare("SELECT id_stuff FROM sae203_stuff_favoris WHERE id_utilisateur = ?");
    $stmtFav->execute([$user_id]);
    $favoris_ids = array_column($stmtFav->fetchAll(PDO::FETCH_ASSOC), 'id_stuff');
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Explorer les Stuffs</title>
    <link rel="stylesheet" href="../css/global.css">
    <link rel="stylesheet" href="../css/explorer_stuffs.css">
</head>
<body>

<?php include '../includes/header.php'; ?>

<div class="explorer-container">
    <div id="stuffList">
        <div class="explorer-title">🌍 Explorer les stuffs de la communauté</div>
        <label>
            <input class="search" placeholder="🔍 Rechercher un stuff...">
        </label>
        <button class="sort" data-sort="nom_stuff">Trier par nom ⬇️</button>

        <ul class="list">
            <?php foreach ($stuffs as $stuff): ?>
                <li>
                    <div class="stuff-card">
                        <span class="nom_stuff"><?= htmlspecialchars($stuff['nom_stuff']) ?></span>
                        <div class="stuff-creator">par <?= htmlspecialchars($stuff['pseudo']) ?><?= ($user_id && $stuff['id_utilisateur'] == $user_id) ? ' (moi)' : '' ?></div>
                        <div class="stuff-details">
                            Ceinture : <?= htmlspecialchars($stuff['ceinture']) ?>,<br>
                            Bouclier : <?= htmlspecialchars($stuff['bouclier']) ?>,<br>
                            Bottes : <?= htmlspecialchars($stuff['bottes']) ?>,<br>
                            Anneau : <?= htmlspecialchars($stuff['anneau']) ?>,<br>
                            Amulette : <?= htmlspecialchars($stuff['amulette']) ?>,<br>
                            Chapeau : <?= htmlspecialchars($stuff['chapeau']) ?>,<br>
                            Cape : <?= htmlspecialchars($stuff['cape']) ?>,<br>
                            Familier : <?= htmlspecialchars($stuff['familier']) ?>,<br>
                            Arme : <?= htmlspecialchars($stuff['arme']) ?>
                        </div>
                        <?php if ($user_id && $stuff['id_utilisateur'] != $user_id): ?>
                            <?php if (!in_array($stuff['id_stuff'], $favoris_ids)): ?>
                                <a href="ajouter_stuff_favori.php?id_stuff=<?= $stuff['id_stuff'] ?>" class="favori-action">⭐ Ajouter aux favoris</a>
                            <?php else: ?>
                                <span class="favori-action">⭐ Déjà en favori</span>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>
</div>

<script src="../vendor/list.min.js"></script>
<script>
    class List {
        constructor(stuffList, param2) {
            
        }

    }

    const stuffListInstance = new List('stuffList', {
        valueNames: ['nom_stuff']
    });
</script>

<?php include '../includes/footer.php'; ?>
</body>
</html>
