<?php
// Connexion à la base de données
$host = 'localhost';
$dbname = 'gallayp';
$user = 'gallayp';
$pass = 'aemiw4ahtoCha9hei3ka';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erreur de connexion : " . $e->getMessage());
}

//////////////////////
// MONSTRES
//////////////////////

function getAllMonstres(): array
{
    global $pdo;
    $stmt = $pdo->query("SELECT * FROM sae203_bestiaire");
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

function deleteMonstre($id): bool
{
    global $pdo;
    $sql = "DELETE FROM sae203_bestiaire WHERE id_monstre = ?";
    $stmt = $pdo->prepare($sql);
    return $stmt->execute([$id]);
}

//////////////////////
// FAVORIS
//////////////////////

function addFavori($id_utilisateur, $id_monstre): bool
{
    global $pdo;
    $sql = "INSERT INTO sae203_favoris (id_utilisateur, id_monstre) VALUES (?, ?)";
    $stmt = $pdo->prepare($sql);
    return $stmt->execute([$id_utilisateur, $id_monstre]);
}

function isFavori($id_utilisateur, $id_monstre): bool
{
    global $pdo;
    $sql = "SELECT 1 FROM sae203_favoris WHERE id_utilisateur = ? AND id_monstre = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$id_utilisateur, $id_monstre]);
    return $stmt->fetchColumn() !== false;
}

function getFavorisByUtilisateur($id_utilisateur): array
{
    global $pdo;
    $stmt = $pdo->prepare("
        SELECT b.id_monstre, b.Niveau, b.D_tails, b.Cat_gorie
        FROM sae203_favoris f
        JOIN sae203_bestiaire b ON f.id_monstre = b.id_monstre
        WHERE f.id_utilisateur = ?
    ");
    $stmt->execute([$id_utilisateur]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

//////////////////////
// UTILISATEURS
//////////////////////

function registerUser($pseudo, $email, $password): bool
{
    global $pdo;
    $sql = "INSERT INTO sae203_utilisateur (pseudo, email, mot_de_passe, date_inscription) VALUES (?, ?, ?, NOW())";
    $stmt = $pdo->prepare($sql);
    return $stmt->execute([
        $pseudo,
        $email,
        password_hash($password, PASSWORD_DEFAULT)
    ]);
}

function loginUser($pseudo, $password) {
    global $pdo;
    $sql = "SELECT * FROM sae203_utilisateur WHERE pseudo = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$pseudo]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user['mot_de_passe'])) {
        return $user;
    }
    return false;
}

