<?php
global $pdo;
if (session_status() === PHP_SESSION_NONE) {
    session_set_cookie_params([
        'lifetime' => 0,
        'path' => '/',
        'domain' => '',
        'secure' => isset($_SERVER['HTTPS']),
        'httponly' => true,
        'samesite' => 'Lax'
    ]);
    session_start();
}

require_once 'db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../users/login.php");
    exit;
}

$erreur = '';
$success = '';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $id_utilisateur = $_SESSION['user_id'];
    $nom_stuff = trim($_POST['nom_stuff'] ?? '');

    $equipements = [
        'ceinture', 'bouclier', 'bottes', 'anneau', 'amulette',
        'chapeau', 'cape', 'familier', 'arme'
    ];

    $valeurs = [];
    foreach ($equipements as $item) {
        $valeurs[$item] = trim($_POST[$item] ?? '');
    }

    if ($nom_stuff === '') {
        $erreur = "Le nom du stuff est requis.";
    } else {
        $stmt = $pdo->prepare("
            INSERT INTO sae203_stuffs 
            (id_utilisateur, nom_stuff, ceinture, bouclier, bottes, anneau, amulette, chapeau, cape, familier, arme) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ");
        $stmt->execute([
            $id_utilisateur,
            $nom_stuff,
            $valeurs['ceinture'],
            $valeurs['bouclier'],
            $valeurs['bottes'],
            $valeurs['anneau'],
            $valeurs['amulette'],
            $valeurs['chapeau'],
            $valeurs['cape'],
            $valeurs['familier'],
            $valeurs['arme']
        ]);
        $success = "🎉 Stuff enregistré avec succès !";
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Créer un Stuff</title>
    <link rel="stylesheet" href="../css/header.css">
    <link rel="stylesheet" href="../css/global.css">
    <link rel="stylesheet" href="../css/creer_stuff.css">
</head>
<body>

<?php include '../includes/header.php'; ?>

<div class="creer-stuff-container">
    <h1>📦 Créer un nouveau stuff</h1>

    <?php if ($erreur): ?>
        <p class="message erreur"><?= htmlspecialchars($erreur) ?></p>
    <?php elseif ($success): ?>
        <p class="message success"><?= htmlspecialchars($success) ?></p>
    <?php endif; ?>

    <form method="post" class="form-stuff">
        <label>Nom du stuff* : <input type="text" name="nom_stuff" required></label>
        <label>Ceinture : <input type="text" name="ceinture"></label>
        <label>Bouclier : <input type="text" name="bouclier"></label>
        <label>Bottes : <input type="text" name="bottes"></label>
        <label>Anneau : <input type="text" name="anneau"></label>
        <label>Amulette : <input type="text" name="amulette"></label>
        <label>Chapeau : <input type="text" name="chapeau"></label>
        <label>Cape : <input type="text" name="cape"></label>
        <label>Familier : <input type="text" name="familier"></label>
        <label>Arme : <input type="text" name="arme"></label>

        <button type="submit">💾 Enregistrer</button>
    </form>

    <p style="text-align:center;"><a href="../users/profil.php">⬅ Retour au profil</a></p>
</div>

<?php include '../includes/footer.php'; ?>
</body>
</html>
