<?php
if (session_status() === PHP_SESSION_NONE) {
    session_set_cookie_params([
        'lifetime' => 0,
        'path' => '/',
        'domain' => '',
        'secure' => isset($_SERVER['HTTPS']),
        'httponly' => true,
        'samesite' => 'Lax'
    ]);
    session_start();
}

require_once 'db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../users/login.php");
    exit;
}

$id_utilisateur = $_SESSION['user_id'];
$id_monstre = isset($_GET['id_monstre']) ? trim($_GET['id_monstre']) : '';

// Vérification : ID de monstre invalide
if ($id_monstre === '') {
    header("Location: monstres.php?erreur=id_monstre_invalide");
    exit;
}

// Vérifie si le monstre existe dans la base
$monstreExiste = false;
foreach (getAllMonstres() as $m) {
    if ($m['id_monstre'] === $id_monstre) {
        $monstreExiste = true;
        break;
    }
}

if (!$monstreExiste) {
    header("Location: monstres.php?erreur=monstre_introuvable");
    exit;
}

// N’ajoute que s’il n’est pas déjà en favori
if (!isFavori($id_utilisateur, $id_monstre)) {
    addFavori($id_utilisateur, $id_monstre);
}

// Retour à la page précédente ou au bestiaire
header("Location: " . ($_SERVER['HTTP_REFERER'] ?? 'monstres.php'));
exit;
