<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Chemins des pages
$base = "/sae203";
$sections = [
    "Accueil"     => "$base/index.php",
    "Bestiaire"   => "$base/php/monstres.php",
    "Guides"      => "$base/php/guides.php",
    "Meta Stuff"  => "$base/php/explorer_stuffs.php"
];

// Utilisateur connecté ?
$connected = isset($_SESSION['user_id']);
$profil_url = $connected ? "$base/users/profil.php" : "$base/users/login.php";
?>

<link rel="stylesheet" href="<?= $base ?>/css/header.css">

<header>
    <div class="container">
        <div class="logo-section">
            <a href="<?= $base ?>/index.php">
                <img src="<?= $base ?>/uploads/logo.png" alt="Logo" class="logo">
            </a>
            <div class="separator"></div>
            <h1>Dofus Helper</h1>
        </div>

        <div class="right-section">
            <nav>
                <ul>
                    <?php foreach ($sections as $name => $link): ?>
                        <li><a href="<?= $link ?>"><?= $name ?></a></li>
                    <?php endforeach; ?>
                </ul>
            </nav>

            <!-- Icône profil -->
            <a href="<?= $profil_url ?>">
                <img src="<?= $base ?>/uploads/profil.svg" alt="Profil" class="profil-icon">
            </a>
        </div>
    </div>
</header>
