<?php
session_start(); // Démarrage de la session pour accéder au panier

// Vérifiez si le formulaire "payer" a été soumis
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['payer'])) {
    unset($_SESSION['cart']); // Vider le panier
    $message = "Merci pour votre achat !"; // Message de remerciement
}

// Vérifiez si le panier contient des produits
$cartItems = $_SESSION['cart'] ?? [];
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panier</title>
    <link rel="stylesheet" href="../css/Style Panier.css">
</head>
<body>
<header>
    <h2><a href="shop.php">Boutique</a></h2>
    <h2><a href="../index.php">Accueil</a></h2>
    <h1>Dokifus</h1>
    <h2><a href="../php/Collabs.php">Collabs</a></h2>
    <h2><a href="#">Nouveauté</a></h2>
</header>

<div class="cart-container">
    <h1>Votre Panier</h1>
    <?php if (!empty($message)): ?>
        <p class="thank-you-message"><?= htmlspecialchars($message); ?></p>
    <?php elseif (empty($cartItems)): ?>
        <p>Votre panier est vide.</p>
    <?php else: ?>
        <table>
            <thead>
            <tr>
                <th>Image</th>
                <th>Produit</th>
                <th>Prix</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($cartItems as $item): ?>
                <tr>
                    <td><img src="../images/boutique/<?= htmlspecialchars($item['image']); ?>" alt="<?= htmlspecialchars($item['name']); ?>" width="50"></td>
                    <td><?= htmlspecialchars($item['name']); ?></td>
                    <td><?= htmlspecialchars($item['price']); ?> €</td>
                </tr>
            <?php endforeach; ?>
            </tbody>
            <tfoot>
            <tr>
                <td colspan="3">
                    <form method="post" action="../php/vider_panier.php">
                        <button type="submit">Vider le panier</button>
                    </form>
                </td>
            </tr>
            <tr>
                <td colspan="3">
                    <form method="post">
                        <button type="submit" name="payer">Payer</button>
                    </form>
                </td>
            </tr>

            </tfoot>
        </table>
    <?php endif; ?>
</div>


<footer>
    <ul>
        <li><a href="#">À propos</a></li>
        <li><a href="#">Politique de confidentialité</a></li>
        <li><a href="contact.php">Contact</a></li>
    </ul>
</footer>
</body>
</html>