<?php
session_start(); // Démarrage de la session pour stocker les données du panier
require_once('../lib/utils.php');

// Charger les données du CSV
$products = getCsvData('../CSV.csv');

// Vérifiez si un produit est ajouté au panier
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['product_id'])) {
    $productId = $_POST['product_id'];

    // Recherchez les informations du produit à partir du CSV
    foreach ($products as $product) {
        if ($product['id'] == $productId) {
            // Ajoutez le produit au panier (stocké dans $_SESSION)
            $_SESSION['cart'][] = $product;
            break;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Boutique</title>
    <link rel="stylesheet" href="../css/Style Boutique.css">
</head>
<body>

<header>
    <h2><a href="../index.php">Accueil</a></h2>
    <h2><a href="../php/shopping-cart.php">Panier</a></h2>
    <h1>Dokifus</h1>
    <h2><a href="../php/Collabs.php">Collabs</a></h2>
    <h2><a href="#">Nouveauté</a></h2>
</header>

<br>

<div class="products-container">
    <?php foreach ($products as $product): ?>
        <div class="product">
            <span class="product-id" hidden><?= htmlspecialchars($product['id']); ?></span>
            <img src="../images/boutique/<?= htmlspecialchars($product['image']); ?>" alt="Produit <?= htmlspecialchars($product['id']); ?>" class="product-img">
            <div class="product-info">
                <div class="product-name"><?= htmlspecialchars($product['name']); ?></div>
                <div class="product-tags"><?= htmlspecialchars($product['tags']); ?></div>
                <div class="product-price"><?= htmlspecialchars($product['price']); ?> €</div>
            </div>
            <div class="cart-action">
                <img src="../images/boutique/panoplie.png" alt="Logo" class="cart-logo"> <!-- Ajout de l'image -->
                <form method="post">
                    <input type="hidden" name="product_id" value="<?= htmlspecialchars($product['id']); ?>">
                    <button class="add-to-cart-btn" type="submit">Ajouter au panier</button>
                </form>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<footer>
    <ul>
        <li><a href="#">À propos</a></li>
        <li><a href="#">Politique de confidentialité</a></li>
        <li><a href="contact.php">Contact</a></li>
    </ul>
</footer>

</body>
</html>
