<?php
function getCsvData($filename): array
{
    $data = [];

    if (($handle = fopen($filename, 'r')) !== FALSE) {
        // Lire les en-têtes si disponibles
        $headers = fgetcsv($handle, 1000, ',', '"', '\\'); // Ajout explicite de $escape

        while (($row = fgetcsv($handle, 1000, ',', '"', '\\')) !== FALSE) { // Ajout explicite de $escape
            // Vérifier si le nombre d'éléments dans la ligne correspond au nombre d'en-têtes
            if (count($headers) === count($row)) {
                $data[] = array_combine($headers, $row);
            } else {
                // Vous pouvez loguer une erreur ou ignorer silencieusement cette ligne
                error_log("Ligne ignorée : " . implode(',', $row));
            }
        }
        fclose($handle);
    }
    return $data;
}

