<?php
    // importation des données de test, en attendant la lecture du fichier CSV
    require_once "../debug.php";
    // chargement des fonctions
    require_once "../lib/utils.php";
    // récupértation de la liste dans le fichier ressources.csv
    // todo
    // preparation des données pour l'affichage détaillé
    $ressources = [];
    foreach ($donnee as $pdf) {
        // on ajoute le tableau indexé des infos sur le pdf
        // dans un tableau indexé par le nom de la resource qui est
        // dans un tableau indexé par le nom du semestre (mise en abyme)
        // nouvelle structure :
        //           Semestre...
        //                Ressource...
        //                      fichier...
        //                Ressource...
        //                      fichier...
        //                      fichier...
        //           Semestre...
        //                Ressource...
        //                      fichier...
        $ressources[$pdf['semestre']] [$pdf['ressource']][] = $pdf;
    }

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Les supports de CM du S1 MMI</title>
</head>
<body>
<header>
    <nav>
        <ul>
            <li>
                <a href="/index.php"><span class="" menu">Accueil</span></a>
            </li>
            <li>
                <a href="/formation.php"><span class="" menu">BUT MMI</span></a>
            </li>
            <?php
                // un élément par semestre de formation : voir la doc de la fonction array_keys() pour une meilleure façon de faire
                for ($i = 1; $i <= 6; $i++) {
                    ?>
                    <li><span href="/semestres/S<?php echo $i ?>.php"><span class="" menu">S<?php echo $i ?></span></a>
                    </li>
                <?php } ?>
        </ul>
    </nav>
</header>
<main>
    <?php // extraction des ressources du semestre S1

        foreach ($ressources['S1'] as $ressource => $pdfs) { ?>
            <article id="<?php echo $ressource ?>">
                <header class="ressource"><?php echo $ressource; ?></header>
                <?php // extration des info sur les pdfs de la ressource
                    foreach ($pdfs as $pdf) {
                        ?>
                        <section>
                            <header class="title"><?php echo $pdf['title']; ?></header>
                            <p class="description"><?php echo $pdf['description']; ?></p>
                            <div><a class="link" href="/download.php<?php //question 5
                                ?>">télécharger</a></div>
                            <div><a class="link" href="/view.php<?php //question 5
                                ?>">consulter</a></div>
                        </section>
                    <?php } ?>
            </article>
        <?php } ?>
</main>
<footer>

</footer>
</body>
</html>
