<?php
    require_once "./lib/utils.php";
    require_once "./debug.php";
    $section = [];
    // le format du tableau $donnee n'est pas le plus pratique pour nous, donc on le change dans la
    // Préparation des sections dans un dictionnaire (tableau associatif) indexé par le nom des semestres
    foreach ($donnee as $tabDatum) {
        //si le semestre existe déjà on ajoute la ressource
        if (array_key_exists($tabDatum['semestre'], $section)) {
            $section[$tabDatum['semestre']] .= "<p>{$tabDatum['ressource']}</p>";
        }
        // sinon on le crée avec la première ressource
        else $section[$tabDatum['semestre']] = "<p>{$tabDatum['ressource']}</p>";
    }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Les supports de CM de MMI</title>
    <link rel="stylesheet" href="css/main.css">

</head>
<body>
<header>
    <section>
        <div>logo</div>
    </section>
    <nav>
        <ul>
            <li>
                <a href="/index.php"><span class="menu">Accueil</span></a>
            </li>
            <li>
                <a href="/formation.php"><span class="menu">BUT MMI</span></a>
            </li>
            <?php
                // un élément par semestre de formation
                for ($i = 1; $i <= 6; $i++) {?>
                    <li><a href="/semestres/s<?php echo $i ?>.php"><span class="menu">S<?php echo $i ?></span></a>
                    </li>
            <?php } ?>
        </ul>
    </nav>
</header>
<main>
    <?php
        // un résumé des différents semestres avec juste le nom des ressources par semestre
        // le header de la section contient un lien vers la page du semestre
        foreach ($section as $semestre => $contenu) {
            ?>
            <section>
                <header>
                    <h1><a href="/semestres/<?php echo strtolower($semestre) ?>.php"><?php echo $semestre ?></a></h1>
                </header>
                <?php echo $contenu ?>
            </section>
        <?php } ?>

    <!-- oui il y a un bug : de toute façon vous allez réécrire ce code bientôt -->
</main>
<footer>
    <adresse>
        Le département MMI
    </adresse>
    <section>
        mentions légales
    </section>
    <section>
        réseaux sociaux
    </section>

</footer>
</body>
</html>